﻿using Sunny.UI;
using Helper;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using ZSMusic.Winform.LrcEditor;
using ZSMusic.Model;
namespace  ZSMusic.Winform
{
    public partial class FrmLrcEditor : UIForm
    {
        public FrmMain MyParent { get; set; }
        public FrmLrcEditor()
        {
            InitializeComponent();
        }
        public FrmLrcEditor(Lyric l)
        {
            InitializeComponent();
            CurrentLrc = l;
            LoadLrc(l);
        }
        public FrmLrcEditor(Music s)
        {
            InitializeComponent();
            CurrentLrc =Lyric.Parse( s.Lrc) ;
            LoadLrc(CurrentLrc);
            player.URL = s.Url;
        }
        public bool EditMode { get; set; }
        public Lyric CurrentLrc { get; set; }
        private bool Playing
        {
            get { return player.playState == WMPLib.WMPPlayState.wmppsPlaying; }
            set
            {
                tmrLrc.Enabled = value;
            }
        }
        public LrcWord CurrentWord
        {
            get { return (LrcWord)txtCurrentWord.Tag; }
            set
            {
                txtCurrentWord.Tag = value;
                txtCurrentWord.Text = value.Export;
            }
        }
        public Lyric Generate()
        {
            Lyric l = new Lyric();
            foreach (LrcWord i in lrcView.Items)
            {
                l.Words.Add(i);
            }
            l.Ar = txtAr.Text.Trim();
            l.Al = txtAl.Text.Trim();
            l.By = txtBy.Text.Trim();
            l.Ti = txtTi.Text;
            l.Offset = Helper.ConvertEx.ToInt32(txtOffset.Text, l.Offset);
            return l;
        }
        private void LoadLrc(Lyric l)
        {
            lrcView.Items.Clear();
            foreach (LrcWord i in l.Words)
            {
                lrcView.Items.Add(i);
            }
            txtAl.Text = l.Al;
            txtAr.Text = l.Ar;
            txtBy.Text = l.By;
            txtTi.Text = l.Ti;
            txtOffset.Text = l.Offset.ToString();
            lrcView.SelectedIndex = 0;
        }
        private void FrmLrcEditor_Load(object sender, EventArgs e)
        {
        }
        private void lrcView_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (Playing)
            {
                LrcWord word = lrcView.SelectedItem as LrcWord;
                word.Time = player.Ctlcontrols.currentPosition;
                lrcView.SelectedItem = word;
                //LoadLrc(Generate());
                CurrentWord = word;
            }
        }
        private void txtCurrentWord_TextChanged(object sender, EventArgs e)
        {
            this.AcceptButton = btnOk;
        }
        private void btnOk_Click(object sender, EventArgs e)
        {
            lrcView.SelectedItem = LrcWord.Parse(txtCurrentWord.Text);
        }
        private void tmrLrc_Tick(object sender, EventArgs e)
        {
        }
        #region 操作
        private void 播放暂停ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (Playing)
            {
                player.Ctlcontrols.pause();
            }
            else
            {
                player.Ctlcontrols.play();
            }
        }
        private void 上一句ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (lrcView.SelectedIndex != 0)
                lrcView.SelectedIndex--;
        }
        private void 下一句ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (lrcView.SelectedIndex != lrcView.Items.Count - 1)
                lrcView.SelectedIndex++;
        }
        private void 后退5秒ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            player.Ctlcontrols.currentPosition -= 5;
        }
        private void 前进五秒ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            player.Ctlcontrols.currentPosition += 5;
        }
        private void 退出XToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        private void 插入ToolStripMenuItem_Click(object sender, EventArgs e)
        {
        }
        private void 删除ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            lrcView.Items.Remove(lrcView.SelectedItem);
        }
        #endregion
        private void FrmLrcEditor_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (MyParent != null)
            {
                Lyric l = Generate();
                MyParent.CurrentMusic.Lrc = l.Export;
                MyParent.LoadLrc(l);
            }
        }
        private void 另存为SToolStripMenuItem_Click(object sender, EventArgs e)
        {
            CurrentLrc = Generate();
            if (saveLrc.ShowDialog() == DialogResult.OK && CurrentLrc != null)
            {
                switch (saveLrc.FilterIndex)
                {
                    case 1:
                        CurrentLrc.Save(saveLrc.FileName, Encoding.Default);
                        break;
                    case 2:
                        CurrentLrc.SaveText(saveLrc.FileName, Encoding.Default);
                        break;
                    default:
                        break;
                }
            }
        }
        private void 打开OToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openLrc.ShowDialog() == DialogResult.OK)
            { LoadLrc(Lyric.FromFile(openLrc.FileName, Encoding.Default)); }
        }
        private void 新建NToolStripMenuItem_Click(object sender, EventArgs e)
        {
            EditTextDialog f = new EditTextDialog();
            if (f.ShowDialog() == DialogResult.OK)
            {
                LoadLrc(Lyric.Create(f.Result));
            }
        }
        private void 加载音乐MToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MusicDialog f = new MusicDialog();
            if (f.ShowDialog() == DialogResult.OK)
            {
                player.URL = f.txtUrl.Text;
            }
        }
    }
}
